/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import oracle.ldap.util.LDIFReader;
import oracle.ldap.util.LDIFRecord;

public class LDIFWriter {
    private static final String lineSeparator = System.getProperty("line.separator");
    private int maxLineLen = 76;
    private boolean wrap = true;
    private static final String ENCODING = "UTF8";
    private BufferedWriter outBuf = null;

    public LDIFWriter() throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, ENCODING));
    }

    public LDIFWriter(String string) throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), ENCODING));
    }

    public LDIFWriter(File file) throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
    }

    public LDIFWriter(OutputStream outputStream) throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter(outputStream, ENCODING));
    }

    public LDIFWriter(String string, boolean bl) throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), ENCODING));
        this.wrap = bl;
    }

    public LDIFWriter(File file, boolean bl) throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
        this.wrap = bl;
    }

    public LDIFWriter(OutputStream outputStream, boolean bl) throws IOException {
        this.outBuf = new BufferedWriter(new OutputStreamWriter(outputStream, ENCODING));
        this.wrap = bl;
    }

    private void ensureOpen() throws IOException {
        if (this.outBuf == null) {
            throw new IOException("Stream closed");
        }
    }

    public void newLine() throws IOException {
        this.ensureOpen();
        this.outBuf.write(lineSeparator);
    }

    private void writeAttribute(String string) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        if (string == null || (n = string.length()) == 0) {
            return;
        }
        this.ensureOpen();
        if (!this.wrap) {
            this.outBuf.write(string);
        } else {
            n3 = Math.min(n, this.maxLineLen);
            while (true) {
                this.outBuf.write(string.substring(n2, n3));
                n2 = n3;
                n3 = Math.min(n - n3, this.maxLineLen);
                if (n3 == 0) break;
                this.newLine();
                this.outBuf.write(32);
                n3 += n2;
            }
        }
    }

    void writeAttribute(String string, String string2) throws IOException {
        if (null == string || null == string2) {
            return;
        }
        this.writeAttribute(string + ": " + string2);
        this.newLine();
        this.outBuf.flush();
    }

    public void setMaxLineLen(int n) {
        this.maxLineLen = n;
    }

    public void setWrap(boolean bl) {
        this.wrap = bl;
    }

    public void writeEntry(LDIFRecord lDIFRecord) throws IOException {
        this.ensureOpen();
        this.outBuf.write(lDIFRecord.getRecordAsString(false, this.wrap));
        this.outBuf.flush();
    }

    public void writeEntryAsComment(LDIFRecord lDIFRecord) throws IOException {
        this.ensureOpen();
        this.outBuf.write(lDIFRecord.getRecordAsString(true, this.wrap));
        this.outBuf.flush();
    }

    public void writeEntry(Vector vector) throws IOException {
        int n;
        if (vector == null || (n = vector.size()) == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.writeAttribute((String)vector.elementAt(n2));
            this.newLine();
            ++n2;
        }
        this.newLine();
    }

    public void writeComment(String string) throws IOException {
        this.ensureOpen();
        this.outBuf.write("# " + string);
        this.outBuf.newLine();
    }

    public synchronized void close() throws IOException {
        if (this.outBuf != null) {
            this.outBuf.flush();
            this.outBuf.close();
        }
        this.outBuf = null;
    }

    private static void test1(String string, String string2) {
        LDIFReader lDIFReader = null;
        LDIFWriter lDIFWriter = null;
        String[] stringArray = new String[]{"jpegphoto"};
        try {
            lDIFReader = new LDIFReader(string);
            lDIFReader.setBinaryAttributes(stringArray);
            lDIFWriter = new LDIFWriter(string2);
        }
        catch (Exception exception) {
            System.err.println("Error while opening LDIF file ");
            System.err.println(exception.toString());
            System.exit(1);
        }
        try {
            LDIFRecord lDIFRecord = null;
            while ((lDIFRecord = lDIFReader.nextRecord()) != null) {
                lDIFWriter.writeEntry(lDIFRecord);
                lDIFWriter.newLine();
            }
            lDIFReader.close();
            lDIFWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Error while reading/writing the LDIF File ");
            System.exit(1);
        }
    }

    private static void test2(String string, String string2) {
        LDIFReader lDIFReader = null;
        LDIFWriter lDIFWriter = null;
        try {
            lDIFReader = new LDIFReader(string);
            lDIFWriter = new LDIFWriter(string2);
        }
        catch (Exception exception) {
            System.err.println("Error while opening the LDIF file ");
            System.err.println(exception);
            System.exit(1);
        }
        try {
            Vector vector = lDIFReader.nextEntry();
            while (vector != null) {
                lDIFWriter.writeEntry(vector);
                vector = lDIFReader.nextEntry();
            }
            lDIFWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Error while reading/writing the LDIF File ");
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage: java LDIFWriter <FILE1> <FILE2> ....");
            System.exit(1);
        }
        LDIFWriter.test1(stringArray[0], stringArray[1] + ".1");
        LDIFWriter.test2(stringArray[0], stringArray[1] + ".2");
        System.exit(0);
    }
}

